VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Miller-Rabin Primality Test"
   ClientHeight    =   5550
   ClientLeft      =   45
   ClientTop       =   360
   ClientWidth     =   4980
   Icon            =   "MRDemo.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   ScaleHeight     =   5550
   ScaleWidth      =   4980
   StartUpPosition =   1  'CenterOwner
   Begin VB.TextBox txA 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   420
      Left            =   3525
      TabIndex        =   1
      ToolTipText     =   "Entering a number here overrides random numbers"
      Top             =   1410
      Width           =   1275
   End
   Begin VB.TextBox txResult 
      BackColor       =   &H8000000F&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   420
      Left            =   210
      Locked          =   -1  'True
      TabIndex        =   13
      TabStop         =   0   'False
      ToolTipText     =   "Pass if result = 1 or N-1 "
      Top             =   1995
      Width           =   3105
   End
   Begin VB.TextBox txC 
      BackColor       =   &H8000000F&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   480
      Left            =   3360
      Locked          =   -1  'True
      TabIndex        =   9
      TabStop         =   0   'False
      ToolTipText     =   "Only one failure proves a composite"
      Top             =   3810
      Width           =   1425
   End
   Begin VB.TextBox txP 
      BackColor       =   &H8000000F&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   480
      Left            =   3360
      Locked          =   -1  'True
      TabIndex        =   8
      TabStop         =   0   'False
      ToolTipText     =   "After 5 passes, the probability of a false result are less than .001%"
      Top             =   3015
      Width           =   1425
   End
   Begin VB.ListBox List1 
      Height          =   2790
      Left            =   240
      MultiSelect     =   2  'Extended
      OLEDragMode     =   1  'Automatic
      TabIndex        =   7
      ToolTipText     =   "For each test, shows iterations run, result, and random-number ""witness"""
      Top             =   2625
      Width           =   2895
   End
   Begin VB.TextBox txCt 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   390
      Left            =   4140
      TabIndex        =   5
      Text            =   "20"
      ToolTipText     =   "Sets the number of tests to run"
      Top             =   2010
      Width           =   645
   End
   Begin VB.TextBox txCalc 
      BackColor       =   &H8000000F&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   420
      Left            =   210
      Locked          =   -1  'True
      TabIndex        =   4
      TabStop         =   0   'False
      ToolTipText     =   "Compute R ^ M mod N and  R ^ M * (2 ^ X) mod N"
      Top             =   1410
      Width           =   3105
   End
   Begin VB.TextBox txR 
      BackColor       =   &H8000000F&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   420
      Left            =   3525
      Locked          =   -1  'True
      TabIndex        =   3
      TabStop         =   0   'False
      ToolTipText     =   "Random number R between 1 and N-1"
      Top             =   825
      Width           =   1275
   End
   Begin VB.TextBox txNCalc 
      BackColor       =   &H80000016&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   420
      Left            =   210
      Locked          =   -1  'True
      TabIndex        =   2
      TabStop         =   0   'False
      ToolTipText     =   "N-1 =  M * (2 ^ X)"
      Top             =   825
      Width           =   3105
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Test"
      Default         =   -1  'True
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   540
      Left            =   3345
      TabIndex        =   10
      Top             =   4845
      Width           =   1455
   End
   Begin VB.TextBox txN 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   420
      Left            =   210
      OLEDropMode     =   2  'Automatic
      TabIndex        =   0
      Text            =   "408578079812495020965775207   "
      Top             =   165
      Width           =   4575
   End
   Begin VB.Label lbCounter 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   420
      Left            =   3375
      TabIndex        =   16
      ToolTipText     =   "Iterations of each test (up to 2 ^ X) "
      Top             =   2050
      Width           =   500
   End
   Begin VB.Label lbAdvice 
      Height          =   375
      Left            =   2625
      TabIndex        =   15
      Top             =   1425
      Visible         =   0   'False
      Width           =   2175
   End
   Begin VB.Label lbResult 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000007&
      Height          =   285
      Left            =   3330
      TabIndex        =   14
      Top             =   4455
      Width           =   1470
   End
   Begin VB.Label Label3 
      Caption         =   "Fail"
      Height          =   285
      Left            =   3360
      TabIndex        =   12
      Top             =   3540
      Width           =   1095
   End
   Begin VB.Label Label2 
      Caption         =   "Pass"
      Height          =   270
      Left            =   3360
      TabIndex        =   11
      Top             =   2700
      Width           =   1125
   End
   Begin VB.Label Label1 
      Caption         =   "x"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   210
      Left            =   3970
      TabIndex        =   6
      Top             =   2020
      Width           =   180
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'A VB6 implementation of Miller-Rabin Primality Test up to 27-Digit Numbers
' 2008 Michael M. Ross
'Modular Exponentiation code  David Ireland - D.I. Management Services
'Hexadecimal conversion code @ Art Araya - Salty Brine Software

Private blRun As Boolean, blStop As Boolean
   
Private Sub Command1_Click()
    MRTest
    blRun = False
End Sub

Private Sub MRTest()
'On Error GoTo errout
    Dim n As Variant, nn As Variant, rs As Variant, rn As Variant
    Dim ax As String, nx As String, nnx As String, nnm As String, ncs As String
    Dim cnt As Long, pcnt As Long, ccnt As Long, nc As Long, exp As Long
    Dim blPass As Boolean
    
    List1.Clear
    txP = " 0"
    txC = " 0"
    lbResult = vbNullString
    cnt = 0
    pcnt = 0
    ccnt = 0
    nc = 0
    blRun = True
    blStop = False
    
    '*************************out of bounds*****************************
    If Val(txN) < 3 Then GoTo errout
    If Len(txN) > 27 Then
        MsgBox "Number cannot exceed 27 digits.", vbCritical
        txN.SetFocus
        Exit Sub
    End If
        
    '**************************Miller-Rabin*****************************
    nn = CDec(txN)
    n = nn - 1
    
    Do While ModOp(n, 2) = 0    'derive n (2 ^ nc * n = n - 1) by factoring powers of 2
        n = n / 2               'the remainder n will be tested/incremented 2 ^ nc
        nc = nc + 1
    Loop
    
    If nc > 1 Then ncs = " ^" + Str$(nc) Else ncs = vbNullString
    txNCalc = Trim$(Str$(nn - 1)) + " =" + Str$(n) + " * 2" + ncs
    
    Randomize
    
    'outer loop - one for each test
    '************************************
    Do
        exp = 1
        cnt = cnt + 1
        If Len(txA) > 0 Then
            rn = Val(txA)
        Else
            rn = Abs(Int((nn - 1) * Rnd)) + 1     'get a random number for the base
            If nn > 2147483648# Then
                If rn ^ 2 < n Then rn = rn ^ 2    'boost for big #s a bit
            End If
        End If
        
        'inner loop - one for each multiple of 2
        '***************************************
        For exp = 1 To 2 ^ nc  '2 to the power of the exponent of 2 above
            
            lbCounter = Str$(exp)
            
            'convert dec numbers to hex
            ax = Dec2Hex(CDec(rn)) 'base
            nx = Dec2Hex(CDec(n * exp)) 'exponent * # of factors of 2
            nnx = Dec2Hex(CDec(nn)) '# being tested
            
            'Perform modular exponentiation (ax ^ nx mod nnx) and return to dec numbers
            rs = CDec(Hex2Dec(mpModExp(ax, nx, nnx)))

            txR = rn
            txCalc = Trim$(Str$(rn)) + " ^" + Str$(n) + " mod" + Str$(nn)
            txResult = rs
            
            'Congruence of 1 is significant only if it occurs on the 1st iteration
            blPass = False
            If (rs = 1 And exp = 1) _
                Or (rs = nn - 1) Then  'Congruence of n-1 is valid if it occurs up to 2^nc
                blPass = True
                txResult = rs
                List1.AddItem "P (" + Trim$(Str$(exp)) + ")" + Str$(rs) + " W:" + Str$(rn)
                Exit For
            End If
            
            DoEvents
            If blStop Then Exit Do
        Next
        '***************************************
        
        If blPass Then
            pcnt = pcnt + 1
            txP = Str$(pcnt)
        Else
            ccnt = ccnt + 1
            txC = Str$(ccnt)
            List1.AddItem "F (" + Trim$(Str$(exp)) + ")" + Str$(rs) + " W:" + Str$(rn)
            Exit Do
        End If
        
        If cnt >= Val(txCt) Then
            Exit Do
        End If
        
        DoEvents
        If blStop Then Exit Do
    Loop
    '****************************************************************

    If pcnt > 0 And ccnt = 0 Then
        lbResult = "Prime"
        lbResult.ForeColor = vbRed
    Else
        lbResult = "Composite"
        lbResult.ForeColor = vbBlue
    End If
    
    HorzScroll
    
    Exit Sub
errout:
    MsgBox "Number cannot be computed.", vbCritical
End Sub

Private Function ModOp(Value1 As Variant, Value2 As Variant) As Double
Dim vratio As Variant

    vratio = CDec(Value1) / CDec(Value2)
    ModOp = CDec(vratio) - Int(vratio)

End Function

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    If KeyCode = vbKeyEscape Then
        If blRun Then
            blStop = True
        Else
            End
        End If
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
    End
End Sub

Private Sub txA_Change()
On Error GoTo errout
    If Len(txA) > 0 Then
        txCt = "1"
    End If
errout:
End Sub

Private Sub txA_GotFocus()
    With txA
        .SelStart = 0
        .SelLength = Len(txA)
    End With
End Sub

Private Sub txCt_GotFocus()
    With txCt
        .SelStart = 0
        .SelLength = Len(txCt)
    End With
End Sub

Private Sub txN_GotFocus()
    txN = Trim$(txN)
    With txN
        .SelStart = 0
        .SelLength = Len(txN)
    End With
End Sub

Private Sub txN_Change()
On Error GoTo errout
    txA = vbNullString
    txCt = "20"
    txN = Trim$(txN)
    txN.ToolTipText = Trim$(Str$(Len(txN))) + " digits"
errout:
End Sub
